/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.mother_silverfish.entity.goals;

import com.hollingsworth.mother_silverfish.ModUtil;
import com.hollingsworth.mother_silverfish.entity.MotherSilverfishEntity;
import com.hollingsworth.mother_silverfish.network.Networking;
import com.hollingsworth.mother_silverfish.network.PacketAnimEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.ForgeEventFactory;

public class ChargeGoal
extends Goal {
    MotherSilverfishEntity boss;
    int timeCharging;
    boolean finished;
    boolean startedCharge;
    boolean isCharging;
    boolean hasHit;

    public ChargeGoal(MotherSilverfishEntity silverfishEntity) {
        this.boss = silverfishEntity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8056_() {
        super.m_8056_();
        this.timeCharging = 0;
        this.finished = false;
        this.startedCharge = false;
        this.isCharging = false;
        this.hasHit = false;
        this.boss.isCharging = true;
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.timeCharging >= 105) {
            this.endRam();
        }
        if (this.boss.m_5448_() == null) {
            this.endRam();
        }
        if (!this.startedCharge) {
            Networking.sendToNearby(this.boss.f_19853_, (Entity)this.boss, (Object)new PacketAnimEntity(this.boss.m_142049_(), MotherSilverfishEntity.Animations.CHARGE.ordinal()));
            this.startedCharge = true;
        }
        ++this.timeCharging;
        if (this.timeCharging <= 30 && !this.isCharging) {
            LivingEntity livingentity = this.boss.m_5448_();
            if (livingentity != null) {
                this.boss.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            }
            this.boss.m_21573_().m_26573_();
        }
        if (this.timeCharging > 30) {
            this.isCharging = true;
        }
        if (this.isCharging) {
            if (this.boss.m_21573_() == null || this.boss.m_5448_() == null) {
                this.attack();
                return;
            }
            this.breakBlocks();
            Path path = this.boss.m_21573_().m_7864_(this.boss.m_5448_().m_142538_().m_7494_(), 1);
            if (path == null) {
                return;
            }
            this.breakBlocks();
            this.boss.m_21573_().m_26536_(path, 2.0);
            this.attack();
        }
        if (this.boss != null && this.boss.m_5448_() != null && this.hasHit && ModUtil.distanceFrom(this.boss.m_20182_(), this.boss.m_5448_().m_20182_()) <= 4.0) {
            this.endRam();
        }
    }

    public void breakBlocks() {
        if (!ForgeEventFactory.getMobGriefingEvent((Level)this.boss.f_19853_, (Entity)this.boss)) {
            return;
        }
        Direction facing = this.boss.m_6350_();
        BlockPos facingPos = this.boss.m_142538_().m_7494_().m_142300_(facing);
        for (int i = 0; i < 2; ++i) {
            facingPos = facingPos.m_6630_(i);
            this.destroyBlock(facingPos.m_7494_());
            this.destroyBlock(facingPos.m_142126_());
            this.destroyBlock(facingPos.m_142125_());
            this.destroyBlock(facingPos.m_142128_());
            this.destroyBlock(facingPos.m_142127_());
        }
    }

    public void destroyBlock(BlockPos pos) {
        if (ModUtil.isCorrectHarvestLevel(4, this.boss.f_19853_.m_8055_(pos))) {
            this.boss.f_19853_.m_46961_(pos, true);
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.boss.isCharging = false;
    }

    public void endRam() {
        this.finished = true;
        this.boss.chargeCooldown = this.boss.getChargeCooldown();
        this.boss.isCharging = false;
        this.attack();
    }

    protected void attack() {
        List nearbyEntities = this.boss.f_19853_.m_45976_(LivingEntity.class, new AABB(this.boss.m_142538_()).m_82377_(3.0, 2.0, 3.0));
        for (LivingEntity enemy : nearbyEntities) {
            if (enemy.equals((Object)this.boss)) continue;
            this.boss.m_7327_((Entity)enemy);
            enemy.m_147240_(3.0, (double)Mth.m_14031_((float)(this.boss.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.boss.m_146908_() * ((float)Math.PI / 180)))));
            this.hasHit = true;
        }
    }

    public boolean m_8045_() {
        return !this.finished;
    }

    public boolean m_8036_() {
        return this.boss.m_5448_() != null && this.boss.chargeCooldown <= 0 && this.boss.canCharge();
    }
}

